<?php

use App\Http\Controllers\AnswerController as ControllersAnswerController;
use App\Http\Controllers\Api\AdminController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\CountryController;
use App\Http\Controllers\Api\CourseController;
use App\Http\Controllers\Api\FeedController;
use App\Http\Controllers\Api\PlanCourseController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\CareerController;
use App\Http\Controllers\Api\PermissionController;
use App\Http\Controllers\Api\EventosController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\Api\ClassLifeController;
use App\Http\Controllers\Api\ModuleController;
use App\Http\Controllers\Api\ResourceController;
use App\Http\Controllers\Api\AnswerController;
use App\Http\Controllers\Api\ClassFeedbackController;
use App\Http\Controllers\Api\PlanController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;




Route::post('/loginUser', [UserController::class, 'validateLoginUser']);
Route::post('/register', [UserController::class, 'register']);
Route::post('/loginAdmin', [AdminController::class, 'validateLoginAdmin']);
Route::post('/login', [UserController::class, 'login']);
Route::get('/forgot-password', [ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
Route::post('/forgotPassword', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
Route::post('/password/reset', [ResetPasswordController::class, 'reset']);
Route::get('/listado', [UserController::class, 'enlistuser']);




Route::middleware('auth:sanctum')->group(function () {

    // Rutas GET
    Route::get('/listCountry', [CountryController::class, 'listCountry']);
    Route::get('/showCountry/{id_country}', [CountryController::class, 'showCountry']);
    Route::get('/listPermission', [PermissionController::class, 'listPermission']);
    Route::get('/showPermission/{id_permissions}', [PermissionController::class, 'showPermission']);
    Route::get('/listCategory', [CategoryController::class, 'listCategory']);
    Route::get('/showCategory/{id_category}', [CategoryController::class, 'showCategory']);
    Route::get('/listUser', [UserController::class, 'listUser']);
    Route::get('/showUserCi/{ci_user}', [UserController::class, 'showUserCi']);
    Route::get('/showCorreouser/{correo_user}', [UserController::class, 'showCorreouser']);
    Route::get('/showUser/{id_user}', [UserController::class, 'showUser']);
    Route::get('/listCareer', [CareerController::class, 'listCareer']);
    Route::get('/showCareer/{id_career}', [CareerController::class, 'showCareer']);
    Route::get('/listCourse', [CourseController::class, 'listCourse']);
    Route::get('/showCourse/{id_course}', [CourseController::class, 'showCourse']);
    Route::get('/listAdmin', [AdminController::class, 'listAdmin']);
    Route::get('/showAdmins/{id_admins}', [AdminController::class, 'showAdmins']);
    Route::get('/listFeedback', [FeedController::class, 'listFeedback']);
    Route::get('/showFeedback/{id_feedback}', [FeedController::class, 'showFeedback']);
    Route::get('/listEvents', [EventosController::class, 'listEvents']);
    Route::get('/showEvents/{id_event}', [EventosController::class, 'showEvents']);
    Route::get('/listClass', [ClassLifeController::class, 'listclass']);
    Route::get('/listModule', [ModuleController::class, 'listmodule']);
    Route::get('/showClass/{id_class}', [ClassLifeController::class, 'showclass']);
    Route::get('/showModule/{id_module}', [ModuleController::class, 'showmodule']);
    Route::get('/listResource', [ResourceController::class, 'listresource']);
    Route::get('/showCourse/{id_courses}/modules', [CourseController::class, 'searchCourseWithModules']);
    Route::get('/showModule/{id_module}/classes', [ModuleController::class, 'searchModuleWithClasses']);
    Route::get('/showResource/{id_resource}', [ResourceController::class, 'showresource']);
    Route::get('/listAnswer', [AnswerController::class, 'listAnswer']);
    Route::get('/showAnswer/{id_answer}', [AnswerController::class, 'showAnswer']);
    Route::get('/classes/{id_class}', [ClassLifeController::class, 'getClassById']);
    Route::get('/classes/{id_class}/comments', [ClassFeedbackController::class, 'getCommentsByClass']);
    Route::get('/courses/{id_courses}/comments', [FeedController::class, 'getByCourse']);
    Route::get('/feedback/{id_feedback}/answers', [FeedController::class, 'getAnswersByFeedback']);
    Route::get('/users/{id_user}/courses', [UserController::class, 'getUserCourses']);
    Route::get('/courses/{id_courses}/users', [CourseController::class, 'getCourseUsers']);
    Route::get('/category/{id_category}/courses', [CategoryController::class, 'getCategoryWithCourses']);
    Route::get('/product/{id_product}', [ResourceController::class, 'getProductById']);
    Route::get('/countUserExternal', [UserController::class, 'countUserExternal']);
    Route::get('/countCourse', [CourseController::class, 'countCourse']);
    Route::get('/current-admin', [AdminController::class, 'getCurrentAdmin']);
    Route::get('/active-users/count', [UserController::class, 'countActiveUsers']);
    Route::get('/monthlyStats', [UserController::class, 'monthlyStats']);
    Route::get('/listPlan', [PlanController::class, 'listPlan']);

    //RutasPOST
    Route::post('/logoutUser', [UserController::class, 'logoutUser']);
    Route::post('/logoutAdmin', [AdminController::class, 'logoutAdmin']);
    Route::post('/country', [CountryController::class, 'registerCountry']);
    Route::post('/permission', [PermissionController::class, 'registerPermission']);
    Route::post('/category', [CategoryController::class, 'registerCategory']);
    Route::post('/user', [UserController::class, 'registerUser']);
    Route::post('/career', [CareerController::class, 'registerCareer']);
    Route::post('/course', [CourseController::class, 'registerCourse']);
    Route::post('/admin', [AdminController::class, 'RegisterAdmins']);
    Route::post('/feedback', [FeedController::class, 'RegisterFeedback']);
    Route::post('/events', [EventosController::class, 'registerEvents']);
    Route::post('/class', [ClassLifeController::class, 'registerclass']);
    Route::post('/module', [ModuleController::class, 'registermodule']);
    Route::post('/resource', [ResourceController::class, 'registerresource']);
    Route::post('/answer', [AnswerController::class, 'RegisterAnswer']);
    Route::post('/courses/enroll', [CourseController::class, 'enrollUser']);
    Route::post('/courses/check', [CourseController::class, 'checkEnrollment']);
    Route::post('/registerPlanCourse', [PlanCourseController::class, 'registerPlanCourse']);

    //rutas put, patch
    Route::patch('/country/{id_country}', [CountryController::class, 'upgradePartialCountry']);
    Route::patch('/permission/{id_permission}', [PermissionController::class, 'upgradePartialPermission']);
    Route::patch('/category/{id_category}', [CategoryController::class, 'upgradePartialCategory']);
    Route::patch('/user/{id_user}', [UserController::class, 'upgradePartialUser']);
    Route::patch('/career/{id_career}', [CareerController::class, 'upgradePartialCareer']);
    Route::patch('/course/{id_courses}', [CourseController::class, 'upgradePartialCourse']);
    Route::patch('/admin/{id_admins}', [AdminController::class, 'UpgradePartialAdmins']);
    Route::patch('/feedback/{id_feedback}', [FeedController::class, 'UpgradePartialFeedback']);
    Route::patch('/events/{id_event}', [EventosController::class, 'upgradePartialEvents']);
    Route::patch('/class/{id_class}', [ClassLifeController::class, 'upgradepartialclass']);
    Route::patch('/module/{id_module}', [ModuleController::class, 'upgradePartialmodule']);
    Route::patch('/resource/{id_resource}', [ResourceController::class, 'upgradePartialresource']);
    Route::patch('/answer/{id_answer}', [AnswerController::class, 'UpgradePartialAnswer']);
});


Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});