<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('course_user', function (Blueprint $table) {
            $table->unsignedBigInteger('external_user_id');
            $table->foreignId('id_courses')->constrained('courses_life', 'id_courses');
            $table->timestamps();
            
            // Clave primaria compuesta
            $table->primary(['external_user_id', 'id_courses']);
            $table->index('external_user_id');
            $table->index('id_courses');

        });
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('course_user');
    }
};