<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('feedback_life', function (Blueprint $table) {
            $table->id('id_feedback');
            $table->text('coment')->nullable();
            $table->string('status_feedback', 50)->nullable();
            $table->foreignId('id_courses')->nullable()->constrained('courses_life', 'id_courses');
            $table->foreignId('id_class')->nullable()->constrained('class', 'id_class');

            $table->unsignedBigInteger('external_user_id')->nullable();

            // Índice opcional para mejorar consultas
            $table->index('external_user_id');
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('feedback_life');
    }
};
