<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('resources_life', function (Blueprint $table) {
            $table->id('id_resource');
            $table->string('name_resource', 100);
            $table->string('description_resource', 300);
            $table->string('resource');
            $table->foreignId('id_courses')->nullable()->constrained('courses_life', 'id_courses');
            $table->foreignId('id_class')->nullable()->constrained('class', 'id_class');
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('resources_life');
    }
};
