<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('class', function (Blueprint $table) {
            $table->id('id_class');
            $table->string('title', 100);
            $table->string('description', 200);
            $table->string('name_img_class')->nullable();
            $table->text('image_class')->nullable();
            $table->string('url_video', 500)->nullable();
            $table->foreignId('id_module')->constrained('module', 'id_module');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('class');
    }
};
