<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'users_life',
            function (Blueprint $table) {
                $table->id('id_user');
                $table->string('nombre_user', 100);
                $table->string('apellido_user', 100);
                $table->string('ci_user', 30);
                $table->string('correo_user', 100);
                $table->string('password_user', 255); // Cambiado a 255 para hash
                $table->string('status_user', 50);
                $table->string('name_img_user')->nullable();
                $table->text('image_user')->nullable();
                $table->foreignId('id_paises')->nullable()->constrained('paises_life', 'id_paises');
                $table->foreignId('id_permissions')->nullable()->constrained('permissions_life', 'id_permissions');
                $table->timestamps();
            }
        );

        // Insertar usuario administrador inicial
        DB::table('users_life')->insert([
            'nombre_user' => 'Admin',
            'apellido_user' => 'Sistema',
            'ci_user' => '0000000',
            'correo_user' => 'user@example.com',
            'password_user' => Hash::make('123'), // Contraseña encriptada
            'status_user' => 'active',
            'name_img_user' => 'admin_profile.jpg',
            'image_user' => null,
            'id_paises' => 1, // Asegúrate que exista este país
            'id_permissions' => 1, // Asegúrate que exista este permiso
            'created_at' => now(),
            'updated_at' => now()
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users_life');
    }
};
