<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'courses_life',
            function (Blueprint $table) {
                $table->id('id_courses');
                $table->string('nombre_courses', 100)->nullable();
                $table->string('status_courses', 50)->nullable();
                $table->string('descriptions_courses', 355)->nullable();
                $table->string('name_img_courses')->nullable();
                $table->text('image_courses')->nullable();
                $table->string('url_video', 500)->nullable();
                $table->foreignId('id_category')->constrained('category_life', 'id_category');
                $table->foreignId('id_career')->constrained('career_life', 'id_career');
                $table->timestamps();
            }
        );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('courses_life');
    }
};
