<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'career_life',
            function (Blueprint $table) {
                $table->id('id_career');
                $table->string('nombre_career', 100)->nullable();
                $table->string('descripcion_career', 300)->nullable();
                $table->string('name_img_career')->nullable();
                $table->text('image_career')->nullable();
                $table->string('status_career', 50)->nullable();
                $table->timestamps();
            }
        );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('career_life');
    }
};
