<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'events_life',
            function (Blueprint $table) {
                $table->id('id_events');
                $table->string('title_events', 255)->nullable();
                $table->string('decriptions_events', 355)->nullable();
                $table->string('name_img_events')->nullable();
                $table->text('image_events')->nullable();
                $table->dateTime('date_events')->nullable();
                $table->integer('duration_events')->nullable();
                $table->string('url_events', 500)->nullable();
                $table->string('status_events', 50)->nullable();
                $table->foreignId('id_admins')->constrained('admins_life', 'id_admins');
                $table->timestamps();
            }
        );

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('events_life');
    }
};
