<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'admins_life',
            function (Blueprint $table) {
                $table->id('id_admins');
                $table->string('nombre_admins', 100)->nullable();
                $table->string('apellido_admins', 100)->nullable();
                $table->string('ci_admins', 30)->nullable();
                $table->string('correo_admins', 100)->nullable();
                $table->string('password_admins', 255)->nullable(); // Aumenté a 255 para hash seguro
                $table->string('status_admins', 50)->nullable();
                $table->foreignId('id_paises')->nullable()->constrained('paises_life', 'id_paises');
                $table->foreignId('id_permissions')->constrained('permissions_life', 'id_permissions');
                $table->timestamps();
            }
        );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('admins_life');
    }
};
