<?php

return [

    'defaults' => [
        'guard' => 'web',
        'passwords' => 'users',
    ],

    'guards' => [
        'web' => [
            'driver' => 'session',
            'provider' => 'users',
        ],

        'admin' => [ // Guard para admin (BD local)
            'driver' => 'sanctum',
            'provider' => 'admins',
        ],

        'external' => [ // Guard para usuarios externos (BD externa)
            'driver' => 'sanctum',
            'provider' => 'external_users',
        ],
    ],

    'providers' => [
        'users' => [
            'driver' => 'eloquent',
            'model' => App\Models\User::class,
        ],

        'admins' => [ // Provider para admin (BD local)
            'driver' => 'eloquent',
            'model' => App\Models\Admin::class,
        ],

        'external_users' => [ // Provider para usuarios externos (BD externa)
            'driver' => 'eloquent',
            'model' => App\Models\ExternalUser::class,
        ],
    ],

    'passwords' => [
        'users' => [
            'provider' => 'users',
            'table' => 'password_reset_tokens',
            'expire' => 60,
            'throttle' => 60,
        ],
    ],

    'password_timeout' => 10800,
];
