<?php

namespace App\Services;

use App\Models\PasswordResetToken;
use App\Models\User;
use Illuminate\Support\Str;
use Carbon\Carbon;

class PasswordResetService
{
    // Generar y guardar un token de restablecimiento
    public function createToken(User $user)
    {
        // Eliminar tokens existentes para el usuario
        PasswordResetToken::where('id_user', $user->id_user)->delete();

        // Crear un nuevo token
        $token = Str::random(60);
        $expiresAt = Carbon::now()->addMinutes(60); // Token válido por 60 minutos

        PasswordResetToken::create([
            'id_user' => $user->id_user,
            'token' => $token,
            'expires_at' => $expiresAt,
        ]);

        return $token;
    }

    // Validar un token
    public function validateToken($token)
    {
        return PasswordResetToken::where('token', $token)
            ->where('expires_at', '>', now())
            ->first();
    }

    // Eliminar un token
    public function deleteToken($token)
    {
        PasswordResetToken::where('token', $token)->delete();
    }
}
