<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class Base64FileRule implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string, ?string=): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        // Verifica si la cadena es un base64 válido
        if (!preg_match('/^[a-zA-Z0-9\/\r\n+]*={0,2}$/', $value)) {
            $fail('El campo :attribute no es un base64 válido.');
        }

        // Opcional: Verifica si se puede decodificar
        if (base64_decode($value, true) === false) {
            $fail('El campo :attribute no es un base64 válido.');
        }
    }
    
}
