<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PasswordResetToken extends Model
{
    use HasFactory;

    protected $table = 'password_reset_tokens';
    protected $fillable = ['id_user', 'token', 'expires_at'];

    // Relación con el modelo UserLife
    public function user()
    {
        return $this->belongsTo(User::class, 'id_user');
    }
}
