<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Feed extends Model
{
    use HasFactory;

    protected $table = "feedback_life";
    protected $primaryKey = 'id_feedback';

    protected $fillable = [
        'coment',
        'status_feedback',
        'id_courses',
        'id_class',
        'external_user_id'

    ];

    public function externalUser()
    {
        return $this->belongsTo(ExternalUser::class, 'external_user_id', 'id');
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'id_courses', 'id_courses');
    }
    public function answers()
    {
        return $this->hasMany(Answer::class, 'id_feedback', 'id_feedback');
    }
}
