<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PasswordResetMail extends Mailable
{
    use Queueable, SerializesModels;

    public $token; // Variable pública para pasar el token a la vista

    /**
     * Create a new message instance.
     *
     * @param string $token
     */
    public function __construct($token)
    {
        $this->token = $token; // Recibe el token como parámetro
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Restablecer contraseña') // Asunto del correo
            ->view('emails.password_reset')    // Vista del correo
            ->with(['token' => $this->token]); // Pasar el token a la vista
    }
}
