<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Services\PasswordResetService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Symfony\Component\HttpFoundation\Response;

class ResetPasswordController extends Controller
{
    protected $passwordResetService;

    public function __construct(PasswordResetService $passwordResetService)
    {
        $this->passwordResetService = $passwordResetService;
    }

    public function reset(Request $request)
    {
        // Validar los datos de entrada
        $request->validate([
            'token' => 'required',
            'password_user' => 'required|confirmed|min:8',
        ]);

        // Buscar el token en la base de datos
        $tokenValid = $this->passwordResetService->validateToken($request->token);

        // Verificar si el token es válido
        if (!$tokenValid) {
            return response()->json(['error' => 'El token no es válido o ha expirado.'], Response::HTTP_BAD_REQUEST);
        }

        // Buscar al usuario asociado al token
        $user = User::find($tokenValid->id_user);

        // Verificar si el usuario existe
        if (!$user) {
            return response()->json(['error' => 'Usuario no encontrado.'], Response::HTTP_NOT_FOUND);
        }

        // Actualizar la contraseña del usuario
        $user->password_user = Hash::make($request->password_user);
        $user->save();

        // Eliminar el token de restablecimiento
        $this->passwordResetService->deleteToken($request->token);

        // Respuesta de éxito
        return response()->json(['message' => $user->nombre_user . ' Tu contraseña ha sido restablecida correctamente.'], Response::HTTP_OK);
    }
}
