<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Services\PasswordResetService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Symfony\Component\HttpFoundation\Response;

class ForgotPasswordController extends Controller
{
    protected $passwordResetService;

    public function __construct(PasswordResetService $passwordResetService)
    {
        $this->passwordResetService = $passwordResetService;
    }

    public function sendResetLinkEmail(Request $request)
    {
        // Validar el correo electrónico
        $request->validate(['correo_user' => 'required|email']);

        // Buscar al usuario por correo
        $user = User::where('correo_user', $request->correo_user)->first();

        // Si el usuario no existe, devolver un error 404
        if (!$user) {
            return response()->json([
                'message' => 'Usuario no encontrado',
            ], Response::HTTP_NOT_FOUND);
        }

        // Generar y guardar el token usando el servicio
        $token = $this->passwordResetService->createToken($user);

        // Generar el enlace de restablecimiento
        $resetLink = url('api/password/reset', $token);

        // Enviar el correo electrónico usando Mail::raw
        $message = "Haga clic en el siguiente enlace para restablecer su contraseña: $resetLink";

        Mail::raw($message, function ($mail) use ($user) {
            $mail->to($user->correo_user)
                ->subject('Restablecer Contraseña');
        });

        // Respuesta exitosa
        return response()->json([
            'message' => 'Se ha enviado un enlace de restablecimiento a tu correo.',
            'reset_link' => $resetLink, // Opcional: devolver el enlace en la respuesta
        ], Response::HTTP_OK);
    }
}
