<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Module;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Storage;


class ModuleController extends Controller
{
    public function listmodule(Request $request)
    {

        $perPage = $request->input('per_page', 20);

        $module = Module::paginate($perPage);

        if ($module->isEmpty()) {
            return response()->json(['message' => 'No se encuentran los modulos'], Response::HTTP_NOT_FOUND);
        }

        return response()->json($module, Response::HTTP_OK);
    }

    public function registermodule(Request $request)
{

    $validator = Validator::make($request->all(), [
        'title_module' => 'required|max:100',
        'description_module' => 'required|max:200',
        'id_courses' => 'required'
    ]);

    if ($validator->fails()) {
        return response()->json(
            ['message' => 'Error al registrar el modulo', 'errors' => $validator->errors()],
            Response::HTTP_BAD_REQUEST
        );
    }

    $module = Module::create([
        'title_module' => $request->title_module,
        'description_module' => $request->description_module,
        'id_courses' => $request->id_courses
    ]);

    if (!$module) {
        return response()->json(
            ['message' => 'Error al registrar el modulo'],
            Response::HTTP_INTERNAL_SERVER_ERROR
        );
    }

    return response()->json([
        'message' => 'Modulo registrado correctamente',
        'data' => $module
    ], Response::HTTP_CREATED);
}

    public function showmodule($id_module)
    {
        $module = module::find($id_module);
        if (!$module) {
            return response()->json(
                ['message' => 'No se encontro el modulo'],
                Response::HTTP_NOT_FOUND
            );
        }
        return response()->json(
            ['message' => $module],
            Response::HTTP_OK
        );
    }

    public function upgradePartialmodule(Request $request, $id_module)
    {

        $module = module::find($id_module);
        if (!$module) {
            return response()->json(
                ['message' => 'No se encontro el modulo'],
                Response::HTTP_NOT_FOUND
            );
        }

        $validator = Validator::make($request->all(), [
            'title_module' => 'sometimes|max:255',
            'description_module' => 'sometimes|max:355',
            'id_courses' => 'nullable'
        ]);



        if ($validator->fails()) {
            return response()->json(
                [
                    'message' => 'Error al actualizar el modulo',
                    'errors' => $validator->errors(),
                ],
                Response::HTTP_BAD_REQUEST
            );
        }

          $errors = [];
          $fields = [
            'title_module',
            'description_module',
            'name_img_module',
            'image_module',
            'id_courses'
        ];

        foreach ($fields as $field) {
            if ($request->has($field) && empty($request->$field)) {
                $errors[$field] = 'El campo ' . $field . ' no puede estar vacío.';
            }
        }

        if (!empty($errors)) {
            return response()->json(
                [
                    'message' => 'Error al actualizar el modulo: campos vacíos',
                    'errors' => $errors,
                ],
                Response::HTTP_BAD_REQUEST
            );
        }

        $dataToUpdate = array_filter($request->only([

            'title_module',
            'description_module',
            'id_courses'


        ]), function ($value) {
            return !empty($value);
        });

        $module->fill($dataToUpdate);
          $module->save();

        return response()->json(
            ['message' => 'modulo actualizado correctamente', 'data' => $module],
            Response::HTTP_OK
        );

    }
    public function searchModuleWithClasses($id_module)
    {
        $module = Module::find($id_module);

        if (!$module) {
            return response()->json(['message' => 'Modulo no encontrado'], 404);
        }

        $classes = $module->classes->map(function($class) {
            $imageBase64 = null;

            if (!empty($class->image_class)) {
                $imagePath = $class->image_class;

                // Normalizar la ruta
                $imagePath = ltrim($imagePath, '/\\');
                $storagePath = 'app/public/' . $imagePath;
                $fullPath = storage_path($storagePath);

                if (file_exists($fullPath) && is_readable($fullPath)) {
                    try {
                        $imageData = file_get_contents($fullPath);

                        // Verificar si realmente es una imagen
                        $mimeType = mime_content_type($fullPath);
                        if (strpos($mimeType, 'image/') === 0) {
                            $imageBase64 = 'data:'.$mimeType.';base64,'.base64_encode($imageData);
                        }
                    } catch (\Exception $e) {
                        // Error al convertir imagen a Base64
                    }
                }
            }

            return [
                'id' => $class->id_class,
                'title' => $class->title,
                'description' => $class->description,
                'image_class' => $class->image_class,
                'image_base64' => $imageBase64,
                'url_video' => $class->url_video,
                'id_module' => $class->id_module,
                'created_at' => $class->created_at,
                'updated_at' => $class->updated_at
            ];
        });

        return response()->json([
            'module' => $module,
            'classes' => $classes,
        ]);
    }
}







