<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\PlanCourse;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Http\Request;

class PlanCourseController extends Controller
{
    public function registerPlanCourse(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'plan_id' => 'required',
            'id_courses' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'message' => 'Error al registrar el PlanCourse',
                'Errors'=> $validator->errors(),
            ], Response::HTTP_BAD_REQUEST);
        }

        $planCourse = PlanCourse::create([
            'plan_id' => $request->plan_id,
            'id_courses' => $request->id_courses,
        ]);

        if(!$planCourse){
            return response()->json([
                'message' => 'Error al guardar el dato',
            ], Response::HTTP_INTERNAL_SERVER_ERROR);
        }

        return response()->json([
            'message' => 'El dato fue registrado correctamente',
            'data' => $planCourse
        ], Response::HTTP_CREATED);
    }
}
