<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Plan;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class PlanController extends Controller
{
    public function listPlan(Request $request){
        $plans = Plan::where('status', 1)->get();

        if($plans->isEmpty()){
            return response()->json([
                'message' => 'No se encontraron planes',
            ], Response::HTTP_NOT_FOUND);
        }

        return response()->json([
            'message' => 'Planes encontrados',
            'planes' => $plans
        ]);
    }

}
