<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('answers', function (Blueprint $table) {
            $table->id('id_answer');
            $table->text('coment'); 
            $table->string('answer_status'); 
            $table->unsignedBigInteger('external_user_id'); 
            $table->index('external_user_id'); 
            $table->unsignedBigInteger('id_feedback'); 
            $table->timestamps(); 
            $table->foreign('id_feedback')
                  ->references('id_feedback')
                  ->on('feedback_life')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('answers');
    }
};
