<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('feedback_life', function (Blueprint $table) {
            $table->id('id_feedback');
            $table->text('coment')->nullable();
            $table->string('status_feedback', 50)->nullable();
            $table->foreignId('id_courses')->nullable()->constrained('courses_life', 'id_courses');
            $table->foreignId('id_class')->nullable()->constrained('class', 'id_class');
            
            $table->unsignedBigInteger('external_user_id')->nullable();

            // Índice opcional para mejorar consultas
            $table->index('external_user_id');
            $table->timestamps();
        });

        // Insertar feedback inicial
        DB::table('feedback_life')->insert([
            [
                'coment' => 'Excelente curso, los contenidos son muy claros y útiles para mi trabajo diario.',
                'status_feedback' => 'active',
                'id_courses' => 1,  // Asume que existe curso con id 1
                'external_user_id' => 1,     // Asume que existe usuario con id 1
                'id_class' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'coment' => 'La clase sobre patrones de diseño fue muy técnica, necesitaría más ejemplos prácticos.',
                'status_feedback' => 'active',
                'id_courses' => 1,
                'external_user_id' => 1,
                'id_class' => 1,     // Asume que existe clase con id 3
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'coment' => 'Buen material pero el ritmo del curso es muy rápido para principiantes.',
                'status_feedback' => 'pending_review',
                'id_courses' => 1,
                'external_user_id' => 1,
                'id_class' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('feedback_life');
    }
};
