<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('id_user'); // Clave foránea para users_life
            $table->string('token'); // Token de restablecimiento
            $table->timestamp('expires_at'); // Fecha de expiración del token
            $table->timestamps();

            // Definir la relación con la tabla users_life
            $table->foreign('id_user')->references('id_user')->on('users_life')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('password_reset_tokens');
    }
};
