<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('resources_life', function (Blueprint $table) {
            $table->id('id_resource');
            $table->string('name_resource', 100);
            $table->string('description_resource', 300);
            $table->string('resource');
            $table->foreignId('id_courses')->nullable()->constrained('courses_life', 'id_courses');
            $table->foreignId('id_class')->nullable()->constrained('class', 'id_class');
            $table->timestamps();
        });

        // Insertar recursos iniciales
        DB::table('resources_life')->insert([
            [
                'name_resource' => 'PDF Guía de Estudio',
                'description_resource' => 'Documento PDF con los conceptos principales del curso',
                'resource' => 'guia_estudio.pdf',
                'id_courses' => 1, // Asume que existe curso con id 1
                'id_class' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name_resource' => 'Presentación Clase 1',
                'description_resource' => 'Diapositivas usadas en la primera clase',
                'resource' => 'presentacion_clase1.pptx',
                'id_courses' => 1,
                'id_class' => 1, // Asume que existe clase con id 1
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'name_resource' => 'Ejercicios Prácticos',
                'description_resource' => 'Archivo con ejercicios para practicar',
                'resource' => 'ejercicios_practicos.docx',
                'id_courses' => 1,
                'id_class' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('resources_life');
    }
};
