<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('class', function (Blueprint $table) {
            $table->id('id_class');
            $table->string('title', 100);
            $table->string('description', 200);
            $table->string('name_img_class')->nullable();
            $table->text('image_class')->nullable();
            $table->string('url_video', 500)->nullable();
            $table->foreignId('id_module')->constrained('module', 'id_module');
            $table->timestamps();
        });

        // Insertar clases iniciales
        DB::table('class')->insert([
            [
                'title' => 'Introducción al Módulo',
                'description' => 'Clase introductoria con los conceptos básicos',
                'name_img_class' => 'intro_thumbnail.jpg',
                'image_class' => null,
                'url_video' => 'https://www.youtube.com/watch?v=ejemplo1',
                'id_module' => 1, // Asume que existe módulo con id 1
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'title' => 'Ejercicios Prácticos',
                'description' => 'Clase con ejercicios para aplicar lo aprendido',
                'name_img_class' => 'practica_thumbnail.jpg',
                'image_class' => null,
                'url_video' => 'https://www.youtube.com/watch?v=ejemplo2',
                'id_module' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'title' => 'Cierre del Módulo',
                'description' => 'Resumen y conclusiones del módulo',
                'name_img_class' => 'cierre_thumbnail.jpg',
                'image_class' => null,
                'url_video' => 'https://www.youtube.com/watch?v=ejemplo3',
                'id_module' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('class');
    }
};
