<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('module', function (Blueprint $table) {
            $table->id('id_module');
            $table->string('title_module');
            $table->text('description_module')->nullable();
            $table->foreignId('id_courses')->constrained('courses_life', 'id_courses');
            $table->timestamps();
        });

        // Insertar módulos iniciales
        DB::table('module')->insert([
            [
                'title_module' => 'Introducción al Curso',
                'description_module' => 'Módulo inicial con los conceptos básicos del curso',
                'id_courses' => 1, // Asume que existe curso con id 1
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'title_module' => 'Conceptos Intermedios',
                'description_module' => 'Módulo que cubre los temas intermedios del curso',
                'id_courses' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'title_module' => 'Módulo Final',
                'description_module' => 'Módulo que cubre los temas avanzados y conclusión',
                'id_courses' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('module');
    }
};
