<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('califications_life', function (Blueprint $table) {
            $table->id('id_califications');
            $table->float('nota_califications', 2)->nullable();
            $table->float('promedio_califications', 2)->nullable();
            $table->string('status_califications', 50)->nullable();
            $table->foreignId('id_courses')->nullable()->constrained('courses_life', 'id_courses');
            $table->foreignId('id_user')->nullable()->constrained('users_life', 'id_user');
            $table->timestamps();
        });

        // Insertar calificaciones iniciales manteniendo la estructura original
        DB::table('califications_life')->insert([
            [
                'nota_califications' => 85,
                'promedio_califications' => 82,
                'status_califications' => 'aprobado',
                'id_courses' => 1,
                'id_user' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nota_califications' => 72,
                'promedio_califications' => 68,
                'status_califications' => 'reprobado',
                'id_courses' => 1,
                'id_user' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nota_califications' => 90,
                'promedio_califications' => 88,
                'status_califications' => 'aprobado',
                'id_courses' => 1,
                'id_user' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('califications_life');
    }
};
