<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'students_life',
            function (Blueprint $table) {
                $table->id('id_students');
                $table->string('primernombre_students', 100)->nullable();
                $table->string('segundonombre_students', 100)->nullable();
                $table->string('primerapellido_students', 100)->nullable();
                $table->string('segundoapellido_students', 100)->nullable();
                $table->string('ci_students', 30)->nullable();
                $table->string('correo_student', 100)->nullable();
                $table->string('status_student', 50)->nullable();
                $table->foreignId('id_paises')->nullable()->constrained('paises_life', 'id_paises');
                $table->timestamps();
            }
        );

        // Insertar estudiantes iniciales
        DB::table('students_life')->insert([
            [
                'primernombre_students' => 'Juan',
                'segundonombre_students' => 'Carlos',
                'primerapellido_students' => 'Pérez',
                'segundoapellido_students' => 'Gómez',
                'ci_students' => '1234567',
                'correo_student' => 'juan.perez@example.com',
                'status_student' => 'active',
                'id_paises' => 1, // Asume que existe país con id 1
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('students_life');
    }
};
