<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'career_life',
            function (Blueprint $table) {
                $table->id('id_career');
                $table->string('nombre_career', 100)->nullable();
                $table->string('descripcion_career', 300)->nullable();
                $table->string('name_img_career')->nullable();
                $table->text('image_career')->nullable();
                $table->string('status_career', 50)->nullable();
                $table->timestamps();
            }
        );

        // Insertar carreras iniciales
        DB::table('career_life')->insert([
            [
                'nombre_career' => 'Desarrollo de Software',
                'descripcion_career' => 'Carrera enfocada en programación y desarrollo de aplicaciones',
                'name_img_career' => 'software_dev.jpg',
                'image_career' => null, // Puedes colocar un base64 de imagen aquí
                'status_career' => 'active',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nombre_career' => 'Diseño Gráfico',
                'descripcion_career' => 'Carrera especializada en diseño visual y comunicación',
                'name_img_career' => 'graphic_design.jpg',
                'image_career' => null,
                'status_career' => 'active',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nombre_career' => 'Marketing Digital',
                'descripcion_career' => 'Carrera orientada a estrategias digitales y redes sociales',
                'name_img_career' => 'digital_marketing.jpg',
                'image_career' => null,
                'status_career' => 'active',
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('career_life');
    }
};
