<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'videomenu_life',
            function (Blueprint $table) {
                $table->id('id_videomenu');
                $table->string('nombre_videomenu', 100)->nullable();
                $table->string('description_videomenu', 300)->nullable();
                $table->string('url_videomenu', 500)->nullable();
                $table->string('url_menu', 500)->nullable();
                $table->string('type_videomenu', 50)->nullable();
                $table->timestamps();
            }
        );

        // Insertar videos de menú iniciales
        DB::table('videomenu_life')->insert([
            [
                'nombre_videomenu' => 'Bienvenida',
                'description_videomenu' => 'Video de bienvenida al sistema',
                'url_videomenu' => 'https://youtu.be/ejemplo-bienvenida',
                'url_menu' => '/welcome',
                'type_videomenu' => 'welcome',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nombre_videomenu' => 'Tutorial Principal',
                'description_videomenu' => 'Video tutorial del menú principal',
                'url_videomenu' => 'https://youtu.be/ejemplo-tutorial',
                'url_menu' => '/dashboard',
                'type_videomenu' => 'tutorial',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nombre_videomenu' => 'Promocional',
                'description_videomenu' => 'Video promocional de nuevas funciones',
                'url_videomenu' => 'https://youtu.be/ejemplo-promo',
                'url_menu' => '/features',
                'type_videomenu' => 'promotional',
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('videomenu_life');
    }
};
