<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'video_life',
            function (Blueprint $table) {
                $table->id('id_video');
                $table->string('nombre_video', 100)->nullable();
                $table->string('description_video', 300)->nullable();
                $table->string('name_img_video')->nullable();
                $table->text('image_video')->nullable();
                $table->string('url_video', 500)->nullable();
                $table->string('status_video', 50)->nullable();
                $table->timestamps();
            }
        );

        // Insertar videos iniciales
        DB::table('video_life')->insert([
            [
                'nombre_video' => 'Introducción al Sistema',
                'description_video' => 'Video tutorial para nuevos usuarios explicando las funciones básicas',
                'name_img_video' => 'intro_thumbnail.jpg',
                'image_video' => null, // Puedes colocar un base64 de imagen aquí
                'url_video' => 'https://www.youtube.com/watch?v=ejemplo1',
                'status_video' => 'active',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nombre_video' => 'Funciones Avanzadas',
                'description_video' => 'Explicación de todas las funciones avanzadas del sistema',
                'name_img_video' => 'avanzado_thumbnail.jpg',
                'image_video' => null,
                'url_video' => 'https://www.youtube.com/watch?v=ejemplo2',
                'status_video' => 'active',
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('video_life');
    }
};
