<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'events_life',
            function (Blueprint $table) {
                $table->id('id_events');
                $table->string('title_events', 255)->nullable();
                $table->string('decriptions_events', 355)->nullable();
                $table->string('name_img_events')->nullable();
                $table->text('image_events')->nullable();
                $table->dateTime('date_events')->nullable();
                $table->integer('duration_events')->nullable();
                $table->string('url_events', 500)->nullable();
                $table->string('status_events', 50)->nullable();
                $table->foreignId('id_admins')->constrained('admins_life', 'id_admins');
                $table->timestamps();
            }
        );

        // Insertar evento inicial
        DB::table('events_life')->insert([
            'title_events' => 'Evento de Inauguración',
            'decriptions_events' => 'Este es el primer evento del sistema para celebrar el lanzamiento de la plataforma.',
            'name_img_events' => 'inauguracion.jpg',
            'image_events' => null, // Aquí podrías poner un base64 de una imagen si lo deseas
            'date_events' => now()->addDays(7), // Una semana a partir de hoy
            'duration_events' => 120, // Duración en minutos
            'url_events' => 'https://tusitio.com/eventos/inauguracion',
            'status_events' => 'active',
            'id_admins' => 1, // Asegúrate que exista este admin
            'created_at' => now(),
            'updated_at' => now()
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('events_life');
    }
};
