<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'admins_life',
            function (Blueprint $table) {
                $table->id('id_admins');
                $table->string('nombre_admins', 100)->nullable();
                $table->string('apellido_admins', 100)->nullable();
                $table->string('ci_admins', 30)->nullable();
                $table->string('correo_admins', 100)->nullable();
                $table->string('password_admins', 255)->nullable(); // Aumenté a 255 para hash seguro
                $table->string('status_admins', 50)->nullable();
                $table->foreignId('id_paises')->nullable()->constrained('paises_life', 'id_paises');
                $table->foreignId('id_permissions')->constrained('permissions_life', 'id_permissions');
                $table->timestamps();
            }
        );

        // Insertar administrador inicial con contraseña encriptada
        DB::table('admins_life')->insert([
            'nombre_admins' => 'Admin',
            'apellido_admins' => 'Inicial',
            'ci_admins' => '0000000',
            'correo_admins' => 'admin@example.com',
            'password_admins' => Hash::make('123'), // Contraseña encriptada
            'status_admins' => 'active',
            'id_paises' => 1, // Asegúrate que exista este país
            'id_permissions' => 1, // Asumiendo que 5 es el permiso de administrador
            'created_at' => now(),
            'updated_at' => now()
        ]);
          // Insertar administrador inicial con contraseña encriptada
          DB::table('admins_life')->insert([
           'nombre_admins' => 'Jordan',
            'apellido_admins' => 'Cuero',
            'ci_admins' => '0000001',
            'correo_admins' => 'jordancuero@winnerworld.io',
            'password_admins' => Hash::make('12345678'), // Contraseña encriptada
            'status_admins' => 'active',
            'id_paises' => 1, // Asegúrate que exista este país
            'id_permissions' => 1, // Asumiendo que 5 es el permiso de administrador
            'created_at' => now(),
            'updated_at' => now()
          ]);
          // Insertar administrador inicial con contraseña encriptada
          DB::table('admins_life')->insert([
            'nombre_admins' => 'Adan',
            'apellido_admins' => 'Gonzalez',
            'ci_admins' => '0000002',
            'correo_admins' => 'agonzalez@harvbest.com',
            'password_admins' => Hash::make('12345678'), // Contraseña encriptada
            'status_admins' => 'active',
            'id_paises' => 1, // Asegúrate que exista este país
            'id_permissions' => 1, // Asumiendo que 5 es el permiso de administrador
            'created_at' => now(),
            'updated_at' => now()
         ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('admins_life');
    }
};
