<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'permissions_life',
            function (Blueprint $table) {
                $table->id('id_permissions');
                $table->string('nombre_permissions', 35)->nullable();
                $table->integer('tipo_permissions')->nullable();
                $table->string('status_permissions', 50)->nullable();
                $table->timestamps();
            }
        );

        // Insertar permisos básicos
        DB::table('permissions_life')->insert([
            [
                'nombre_permissions' => 'Crear registros',
                'tipo_permissions' => 1,
                'status_permissions' => 'active',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nombre_permissions' => 'Leer registros',
                'tipo_permissions' => 2,
                'status_permissions' => 'active',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nombre_permissions' => 'Actualizar registros',
                'tipo_permissions' => 3,
                'status_permissions' => 'active',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nombre_permissions' => 'Eliminar registros',
                'tipo_permissions' => 4,
                'status_permissions' => 'active',
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('permissions_life');
    }
};
