<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('paises_life', function (Blueprint $table) {
            $table->id('id_paises');
            $table->char('iso_paises', 2)->nullable();
            $table->string('nombre_paises', 80)->nullable();
            $table->timestamps();
        });

        // Insertar registro inicial si la tabla está vacía
        DB::table('paises_life')->insertOrIgnore([
            'iso_paises' => 'VE',
            'nombre_paises' => 'Venezuela',
            'created_at' => now(),
            'updated_at' => now()
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::dropIfExists('paises_life');
    }
};
