<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\PasswordResetService;
use Illuminate\Http\Request;
use App\Models\ExternalUser;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Laravel\Sanctum\Sanctum;
use Laravel\Sanctum\PersonalAccessToken;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->bind(PasswordResetService::class, function ($app) {
            return new PasswordResetService();
        });
    }

    /**
     * Bootstrap any application services.
     */

    public function boot()
{
    Auth::provider('external', function ($app, array $config) {
        return new ExternalAuthProvider();
    });
    
    // Configura el guard para Sanctum
    Sanctum::usePersonalAccessTokenModel(PersonalAccessToken::class);
}
}
