<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasFactory, HasApiTokens, Notifiable;
    
    protected $table = "users_life";
    protected $primaryKey = 'id_user';

    protected $fillable = [
        'nombre_user',
        'apellido_user',
        'ci_user',
        'correo_user',
        'password_user',
        'status_user',
        'name_img_user',
        'image_user',
        'id_paises',
        'id_permissions'
    
    ];

    // Relación muchos a muchos con cursos
    public function courses()
    {
        return $this->belongsToMany(Course::class, 'course_user', 'external_user_id', 'id_courses');
    }
}

