<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Module extends Model 
{
    use HasFactory;

    protected $table = "module";

    protected $primaryKey = 'id_module';

    protected $fillable = [
        'title_module',
        'description_module',
        'id_courses' 
    ];

    
    public function classes()
    {
        return $this->hasMany(ClassLife::class, 'id_module', 'id_module');
    }

  
    public function course()
    {
        return $this->belongsTo(Course::class, 'id_courses', 'id_courses');
    }
}

