<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Sanctum\HasApiTokens;

class ExternalUser extends Authenticatable
{
    use HasApiTokens;

    protected $connection = 'afiliados'; 
    protected $table = 'users'; 


    protected $fillable = [
        'id', 
        'username',
        'password',
        'firstname',
        'lastname',
        'phone',
        
    ];


   
    public function tokens()
    {
        return $this->morphMany(
            \App\Models\PersonalAccessToken::class, 
            'tokenable'
        );
    }

    
    public function getAuthPassword()
    {
        return $this->password;
    }


    public function feedbacks()
    {
        return $this->hasMany(Feed::class, 'external_user_id', 'id');
    }

    public function answers()
{
    return $this->hasMany(Answer::class, 'external_user_id', 'id');
}

public function courses()
{
    return $this->belongsToMany(
        Course::class,
        'course_user',
        'external_user_id',
        'id_courses'
    )
    ->using(CourseUser::class) 
    ->withTimestamps();
}

    public function memberships()
{
    return $this->hasMany(Membership_user::class, 'user_id')
                ->where('is_active', true)
                ->where('expire_at', '>', now());
}
}

