<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Course extends Model
{
    use HasFactory;
    protected $connection = 'mysql'; // Nombre de tu conexión a la BD de cursos
    
    protected $table = "courses_life";
    protected $primaryKey = 'id_courses';
    protected $fillable = [
        'nombre_courses',
        'status_courses',
        'descriptions_courses',
        'name_img_courses',
        'image_courses',
        'id_category',
        'id_video',
        'id_career'
    ];

     public function modules()
     {
         return $this->hasMany(Module::class, 'id_courses', 'id_courses');
     }

     public function externalUsers()
     {
         return $this->belongsToMany(
             ExternalUser::class,
             'course_user',
             'id_courses',
             'external_user_id'
         )
         ->using(CourseUser::class) // Especifica el modelo pivot
         ->withTimestamps();
     }

    public function feedbacks()
    {
        return $this->hasMany(Feed::class, 'id_courses', 'id_courses');
    }
}