<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ClassLife extends Model 
{
    use HasFactory;

    protected $table = "class";
    protected $primaryKey = 'id_class';

    protected $fillable = [
        'title',
        'description',
        'image_class',
        'name_img_class',
        'url_video',
        'id_module'
    ];

    // Relación con el módulo
    public function module()
    {
        return $this->belongsTo(Module::class, 'id_module', 'id_module'); 
    }

    public function video()
    {
        return $this->belongsTo(Video::class, 'id_video', 'id_video');
    }
}
