<?php

namespace App\Models;
use App\Models\Feed;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Answer extends Model
{
    use HasFactory;
    protected $table = 'answers';
    protected $primaryKey = 'id_answer';
    protected $fillable = [
        'coment',
        'answer_status',
        'id_feedback',
        'external_user_id'
    ];

    
    public function feedback()
    {
        return $this->belongsTo(    Feed::class, 'id_feedback');
    }

    public function externalUser()
    {
        return $this->belongsTo(ExternalUser::class, 'external_user_id', 'id');
    }
}