<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Student;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpFoundation\Response;


class StudentController extends Controller
{

    public function listStudent(Request $resquest)
    {
        $perPage = $resquest->input('per_page', 20);

        $student = Student::paginate($perPage);


        if ($student->isEmpty()) {

            return response()->json(
                ['message' => 'No se encontro el estudiante'],
                Response::HTTP_NOT_FOUND
            );
        }

        return response()->json(
            $student,
            Response::HTTP_OK
        );
    }

    public function registerStudent(Request $request)
    {

        $validator = Validator::make(
            $request->all(),
            [
            'primernombre_students' => 'required|max:100',
            'segundonombre_students' => 'required|max:100',
            'primerapellido_students' => 'required|max:100',
            'segundoapellido_students' => 'required|max:100',
            'ci_students' => 'required|max:30',
            'correo_student' => 'required|email|max:100|unique:students_life',//cambio
            'status_student' => 'required|max:50',
            'id_paises' => 'required'
            ]
        );


        if ($validator->fails()) {
            return response()->json(
                [
                    'message' => 'Error al registrar el estudiante',
                    'errors' => $validator->errors(),
                ],
                Response::HTTP_BAD_REQUEST
            );
        }



        $student = Student::create([
            'primernombre_students' =>  $request->primernombre_students,
            'segundonombre_students' => $request->segundonombre_students,
            'primerapellido_students' => $request->primerapellido_students,
            'segundoapellido_students' => $request->segundoapellido_students,
            'ci_students' => $request->ci_students,
            'correo_student' => $request->correo_student,
            'status_student' => $request->status_student,
            'id_paises' => $request->id_paises,
        ]);


        if (!$student) {
            return response()->json(
                ['message' => 'Error al guardar el dato'],
                Response::HTTP_INTERNAL_SERVER_ERROR
            );
        }


        return response()->json(
            ['message' => 'El estudiante se registro correctamente',
            'data' => $student],
            Response::HTTP_CREATED
        );
    }


    public function showStudent($id_students)

    {
        $student = Student::find($id_students);
        if (!$student) {


            return response()->json(
              ['message' => 'No se encontro el estudiante'],
              Response::HTTP_NOT_FOUND);
        }

            return response()->json(
                ['message' => $student],
                Response::HTTP_OK);
    }


    public function upgradePartialStudent(Request $request, $id_students)
{
    // Buscar el estudiante por su ID
    $student = Student::find($id_students);
    if (!$student) {
        return response()->json(
            ['message' => 'No se encontró el estudiante'],
            Response::HTTP_NOT_FOUND
        );
    }

    // Validar los datos a actualizar
    $validator = Validator::make($request->all(), [
        'primernombre_students' => 'sometimes|max:100',
        'segundonombre_students' => 'sometimes|max:100',
        'primerapellido_students' => 'sometimes|max:100',
        'segundoapellido_students' => 'sometimes|max:100',
        'ci_students' => 'sometimes|max:30',
        'correo_student' => 'sometimes|email|max:100|unique:students_life,correo_student,' . $student->id,
        'status_student' => 'sometimes|max:50',
        'id_paises' => 'sometimes|integer',
    ]);

    // Si los datos son inválidos, mensaje de error
    if ($validator->fails()) {
        return response()->json(
            [
                'message' => 'Error de validación',
                'errors' => $validator->errors(),
            ],
            Response::HTTP_BAD_REQUEST
        );
    }

    $updatedFields = 0;
    $fieldsToUpdate = [
        'primernombre_students',
        'segundonombre_students',
        'primerapellido_students',
        'segundoapellido_students',
        'ci_students',
        'correo_student',
        'status_student',
        'id_paises',
    ];

    // Actualizar solo campos presentes en la request y no vacíos
    foreach ($fieldsToUpdate as $field) {
        if ($request->has($field)){
            $value = $request->$field;

            // Validar que el campo no esté vacío
            if ($value === null || $value === '') {
                return response()->json(
                    [
                        'message' => 'Error: campo vacío',
                        'error' => "El campo $field no puede estar vacío"
                    ],
                    Response::HTTP_BAD_REQUEST
                );
            }

            $student->$field = $value;
            $updatedFields++;
        }
    }

    // Verificar si hubo campos para actualizar
    if ($updatedFields === 0) {
        return response()->json(
            ['message' => 'No se recibieron campos válidos para actualizar'],
            Response::HTTP_OK
        );
    }

    // Guardar cambios
    if (!$student->save()) {
        return response()->json(
            ['message' => 'Error al guardar los cambios en la base de datos'],
            Response::HTTP_INTERNAL_SERVER_ERROR
        );
    }

    return response()->json(
        [
            'message' => 'Estudiante actualizado correctamente',
            'updated_fields' => $updatedFields,
            'data' => $student
        ],
        Response::HTTP_OK
    );
}


}
