<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Permission;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpFoundation\Response;

class PermissionController extends Controller
{

    public function listPermission(Request $resquest){
        $perPage = $resquest->input('per_page', 20);

        $permissions = Permission::paginate($perPage);



        if($permissions->isEmpty()){
            return response()->json(['message' => 'No se encuentran los permisos'], Response::HTTP_NOT_FOUND);
        }
        return response()->json([$permissions], Response::HTTP_OK);
    }

    public function registerPermission(Request $request){

        $validator = Validator::make($request->all(), [
            'nombre_permissions' => 'required|max:35',
            'tipo_permissions' => 'required',
            'status_permissions' => 'required|max:50'
        ]);



        if($validator->fails()){
            return response()->json(['message' => 'Error al registrar el permiso', 'errors' => $validator->errors()], Response::HTTP_BAD_REQUEST);
        }


        $permissions = Permission::create([
            'nombre_permissions' => $request->nombre_permissions,
            'tipo_permissions' => $request->tipo_permissions,
            'status_permissions' => $request->status_permissions
        ]);


        if(!$permissions){
            return response()->json(['message' => 'Error al registrar el permiso'], Response::HTTP_BAD_REQUEST);
        }
        return response()->json(['message' => 'Permiso registrada correctamente',
        'data' => $permissions], Response::HTTP_CREATED);
    }


     public function showPermission($id_permissions)

     {
         $permission = Permission::find($id_permissions);
         if (!$permission) {


             return response()->json(
               ['message' => 'No se encontro el permiso'],
               Response::HTTP_NOT_FOUND);
         }


             return response()->json(
                 ['message' => $permission],
                 Response::HTTP_OK);
     }


    public function upgradePartialPermission(Request $request, $id_permissions)
    {
        // Buscar el permiso por su ID
        $permission = Permission::find($id_permissions);
        if (!$permission) {
            return response()->json(
                ['message' => 'No se encontró el permiso'],
                Response::HTTP_NOT_FOUND
            );
        }

        // Validar los datos a actualizar
        $validator = Validator::make($request->all(), [
            'nombre_permissions' => 'sometimes|max:35',
            'tipo_permissions' => 'sometimes|string',
            'status_permissions' => 'sometimes|max:50',
        ]);

        // Si los datos son inválidos, mensaje de error
        if ($validator->fails()) {
            return response()->json(
                [
                    'message' => 'Error de validación',
                    'errors' => $validator->errors(),
                ],
                Response::HTTP_BAD_REQUEST
            );
        }

        $updatedFields = 0;
        $fieldsToUpdate = [
            'nombre_permissions',
            'tipo_permissions',
            'status_permissions',
        ];

        // Actualizar solo campos presentes en la request y no vacíos
        foreach ($fieldsToUpdate as $field) {
            if ($request->has($field)) {
                $value = $request->$field;

                // Validar que el campo no esté vacío
                if ($value === null || $value === '') {
                    return response()->json(
                        [
                            'message' => 'Error: campo vacío',
                            'error' => "El campo $field no puede estar vacío"
                        ],
                        Response::HTTP_BAD_REQUEST
                    );
                }

                $permission->$field = $value;
                $updatedFields++;
            }
        }

        // Verificar si hubo campos para actualizar
        if ($updatedFields === 0) {
            return response()->json(
                ['message' => 'No se recibieron campos válidos para actualizar'],
                Response::HTTP_OK
            );
        }

        // Guardar cambios
        if (!$permission->save()) {
            return response()->json(
                ['message' => 'Error al guardar los cambios en la base de datos'],
                Response::HTTP_INTERNAL_SERVER_ERROR
            );
        }

        return response()->json(
            [
                'message' => 'Permiso actualizado correctamente',
                'updated_fields' => $updatedFields,
                'data' => $permission
            ],
            Response::HTTP_OK
        );
    }


}
