<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Module;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Storage;


class ModuleController extends Controller
{
    public function listmodule(Request $request)
    {

        $perPage = $request->input('per_page', 20);

        $module = Module::paginate($perPage);

        if ($module->isEmpty()) {
            return response()->json(['message' => 'No se encuentran los modulos'], Response::HTTP_NOT_FOUND);
        }

        return response()->json($module, Response::HTTP_OK);
    }
    //Registro
    public function registermodule(Request $request)
{
    // Validate the request data
    $validator = Validator::make($request->all(), [
        'title_module' => 'required|max:100',
        'description_module' => 'required|max:200',
        'id_courses' => 'required'
    ]);

    // Check if validation fails
    if ($validator->fails()) {
        return response()->json(
            ['message' => 'Error al registrar el modulo', 'errors' => $validator->errors()],
            Response::HTTP_BAD_REQUEST
        );
    }

    // If validation passes, create the module
    $module = Module::create([
        'title_module' => $request->title_module,
        'description_module' => $request->description_module,
        'id_courses' => $request->id_courses
    ]);

    // Check if the module was created successfully
    if (!$module) {
        return response()->json(
            ['message' => 'Error al registrar el modulo'],
            Response::HTTP_INTERNAL_SERVER_ERROR
        );
    }

    return response()->json([
        'message' => 'Modulo registrado correctamente',
        'data' => $module
    ], Response::HTTP_CREATED);
}

    //Busqueda por id
    public function showmodule($id_module)
    {
        $module = module::find($id_module);
        if (!$module) {
            return response()->json(
                ['message' => 'No se encontro el modulo'],
                Response::HTTP_NOT_FOUND
            );
        }

        //si existe retorna un mensaje con los datos solicitados
        return response()->json(
            ['message' => $module],
            Response::HTTP_OK
        );
    }

    //Actualizacion de datos
    public function upgradePartialmodule(Request $request, $id_module)
    {
        //busqueda por id
        $module = module::find($id_module);
        if (!$module) {
            //si no existe retorna un mensaje de error
            return response()->json(
                ['message' => 'No se encontro el modulo'],
                Response::HTTP_NOT_FOUND
            );
        }

        //valido los datos a actualizar
        $validator = Validator::make($request->all(), [
            'title_module' => 'sometimes|max:255',
            'description_module' => 'sometimes|max:355',
            //'name_img_module' => 'sometimes|max:255',
            //'image_module' => 'nullable|string',
            'id_courses' => 'nullable'
        ]);



        //si los datos son invalidos mensaje de error
        if ($validator->fails()) {
            return response()->json(
                [
                    'message' => 'Error al actualizar el modulo',
                    'errors' => $validator->errors(),
                ],
                Response::HTTP_BAD_REQUEST
            );
        }

        // Validar campos vacíos
          $errors = [];
          $fields = [
            'title_module',
            'description_module',
            'name_img_module',
            'image_module',
            'id_courses'
        ];

        foreach ($fields as $field) {
            if ($request->has($field) && empty($request->$field)) {
                $errors[$field] = 'El campo ' . $field . ' no puede estar vacío.';
            }
        }

    
        if (!empty($errors)) {
            return response()->json(
                [
                    'message' => 'Error al actualizar el modulo: campos vacíos',
                    'errors' => $errors,
                ],
                Response::HTTP_BAD_REQUEST
            );
        }

        /*// Manejo de la imagen
        if ($request->has('image_module') && !empty($request->image_module)) {
            $imageBase64 = $request->image_module;

            // Verificar si la imagen es Base64
            if (preg_match('/^data:image\/(\w+);base64,/', $imageBase64, $type)) {
                $imageBase64 = substr($imageBase64, strpos($imageBase64, ',') + 1);
                $imageData = base64_decode($imageBase64);

                // Comprobar si la decodificación fue exitosa
                if ($imageData === false) {
                    return response()->json(
                        ['message' => 'La imagen Base64 no es válida'],
                        Response::HTTP_BAD_REQUEST
                    );
                }

                // Generar un nombre único para la imagen
                $imageName = uniqid() . '.' . $type[1]; // Usar la extensión extraída
                $imagePath = 'images/' . $imageName;

                // Guardar la imagen en el storage
                Storage::disk('public')->put($imagePath, $imageData);

                // Actualizar el usuario con la nueva imagen
                $module->image_module = $imagePath;
                $module->name_img_module = $imageName;
            } else {
                return response()->json(
                    ['message' => 'La imagen no está en formato Base64'],
                    Response::HTTP_BAD_REQUEST
                );
            }
        }*/

        $dataToUpdate = array_filter($request->only([
            
            'title_module',
            'description_module',
            'id_courses'

           
        ]), function ($value) {
            return !empty($value);
        });

        $module->fill($dataToUpdate);

          //guardar los datos suministrados
          $module->save();

        return response()->json(
            ['message' => 'modulo actualizado correctamente', 'data' => $module],
            Response::HTTP_OK
        );

    }
    public function searchModuleWithClasses($id_module)
    {
        $module = Module::find($id_module);
    
        if (!$module) {
            return response()->json([
                'message' => 'Modulo no encontrado',
            ], 404);
        }
    
        $classes = $module->classes->map(function($class) {
            // Obtener la imagen en base64 si existe
            $imageBase64 = null;
            if ($class->image_class && Storage::disk('public')->exists($class->image_class)) {
                $imageData = Storage::disk('public')->get($class->image_class);
                
                // Obtener el tipo MIME de forma alternativa
                $filePath = storage_path('app/public/'.$class->image_class);
                $mimeType = mime_content_type($filePath);
                
                $imageBase64 = 'data:'.$mimeType.';base64,'.base64_encode($imageData);
            }
    
            return [
                'id' => $class->id_class,
                'title' => $class->title,
                'description' => $class->description,
                'image_class' => $class->image_class, // Ruta original
                'image_class_base64' => $imageBase64, // Imagen en base64
                'url_video' => $class->url_video,
                'id_module' => $class->id_module,
                'created_at' => $class->created_at,
                'updated_at' => $class->updated_at
            ];
        });
    
        return response()->json([
            'module' => $module,
            'classes' => $classes,
        ]);
    }
    
    }




