<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Inscription;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpFoundation\Response;



class InscriptionController extends Controller
{
    
    public function listinscriptions(Request $resquest)
    {
        $perPage = $resquest->input('per_page', 10);

        $inscription = Inscription::paginate($perPage);


        if ($inscription->isEmpty()) {
            return response()->json(['message' => 'No se encuentran las inscripciones'], Response::HTTP_NOT_FOUND);
        }
        return response()->json([$inscription], Response::HTTP_OK);
    }
  
    public function showInscriptions($id_inscription)

    {
        $inscriptions = Inscription::find($id_inscription);
        if (!$inscriptions) {


            return response()->json(
                ['message' => 'No se encontro la inscripcion'],
                Response::HTTP_NOT_FOUND
            );
        }


        return response()->json(
            ['message' => $inscriptions],
            Response::HTTP_OK
        );
    }

    public function RegisterInscription(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'status' => 'required|string',
            'id_user' => 'required',
            'id_courses' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => 'Error al crear la inscripcion', 'errors' => $validator->errors()], Response::HTTP_BAD_REQUEST);
        }


        $inscription = Inscription::create([
            'status' => $request->status,
            'id_user' => $request->id_user,
            'id_courses' => $request->id_courses
            
        ]);

        if (!$inscription) {
            return response()->json(['message' => 'Error al generar la inscripcion'], Response::HTTP_BAD_REQUEST);
        }
        return response()->json([
            'message' => 'inscripcion generada correctamente',
            'data' => $inscription
        ], Response::HTTP_CREATED);
    }

  
    public function UpgradePartialInscription(Request $request, $id_answer)
    {
       
    $inscription = Inscription::find($id_answer);
    if (!$inscription) {
        
        return response()->json(
            ['message' => 'No se encontró la inscripcion'],
            Response::HTTP_NOT_FOUND
        );
    }

    $validator = Validator::make($request->all(), [
            'status' => 'sometimes|string',
            'id_user' => 'sometimes',
            'id_courses' => 'sometimes',
    ]);

    if ($validator->fails()) {
        return response()->json(
            [
                'message' => 'Error al actualizar la inscripcion',
                'errors' => $validator->errors(),
            ],
            Response::HTTP_BAD_REQUEST
        );
    }

    // Validar campos vacíos
    $errors = [];
    $fields = [
        'status',
        'id_user',
        'id_courses',
    ];

    foreach ($fields as $field) {
        if ($request->has($field) ){
            if (empty($request->$field)) {
                $errors[$field] = 'El campo ' . $field . ' no puede estar vacío.';
            }
        }
    }

    if (!empty($errors)) {
        return response()->json(
            [
                'message' => 'Error al actualizar la inscripcion: campos vacíos',
                'errors' => $errors,
            ],
            Response::HTTP_BAD_REQUEST
        );
    }

    $dataToUpdate = array_filter($request->only([
       'status',
        'id_user',
        'id_courses',
    ]), function ($value) {
        return !empty($value); 
    });

    $inscription->fill($dataToUpdate);
    $inscription->save();

   
    return response()->json(
        [
            'message' => 'inscripcion actualizada correctamente',
            'data' => $inscription,
        ],
        Response::HTTP_OK);
}


}
