<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Feed;
use App\Models\Course;
use App\Models\Answer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpFoundation\Response;

class FeedController extends Controller


{

    public function listFeedback(Request $resquest)
    {
        $perPage = $resquest->input('per_page', 10);

        $feedback = Feed::orderBy('created_at', 'asc')->paginate($perPage);


        if ($feedback->isEmpty()) {
            return response()->json(['message' => 'No se encuentran los comentarios'], Response::HTTP_NOT_FOUND);
        }
        return response()->json([$feedback], Response::HTTP_OK);
    }


    public function registerFeedback(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'coment' => 'required',
            'status_feedback' => 'required|max:50',
            'id_courses' => 'required',
            'external_user_id' => 'required',
            'id_class' => 'required'
        ]);



        if ($validator->fails()) {
            return response()->json(['message' => 'Error al crear el comentario', 'errors' => $validator->errors()], Response::HTTP_BAD_REQUEST);
        }


        $feedback = Feed::create([
            'coment' => $request->coment,
            'status_feedback' => $request->status_feedback,
            'id_courses' => $request->id_courses,
            'external_user_id' => $request->external_user_id,
            'id_class' => $request->id_class
        ]);

        if (!$feedback) {
            return response()->json(['message' => 'Error al generar el comentario'], Response::HTTP_BAD_REQUEST);
        }
        return response()->json([
            'message' => 'comentario generado correctamente',
            'data' => $feedback
        ], Response::HTTP_CREATED);
    }


    public function showFeedback($id_feedback)

    {
        $feedback = Feed::find($id_feedback);
        if (!$feedback) {


            return response()->json(
                ['message' => 'No se encontro el comentario'],
                Response::HTTP_NOT_FOUND
            );
        }


        return response()->json(
            ['message' => $feedback],
            Response::HTTP_OK
        );
    }


   public function upgradePartialFeedback(Request $request, $id_feedback)
{
    // Buscar el feedback por su ID
    $feedback = Feed::find($id_feedback);
    if (!$feedback) {
        // Si no existe, retorna un mensaje de error
        return response()->json(
            ['message' => 'No se encontró el comentario'],
            Response::HTTP_NOT_FOUND
        );
    }

    // Validar los datos a actualizar
    $validator = Validator::make($request->all(), [
        'coment' => 'sometimes|required|string', // "sometimes" permite que el campo sea opcional
        'status_feedback' => 'sometimes|required|max:50',
        'id_courses' => 'sometimes|required|integer',
        'external_user_id' => 'sometimes|required|integer',
        'id_class' => 'sometimes|required|integer',
    ]);

    // Si los datos son inválidos, mensaje de error
    if ($validator->fails()) {
        return response()->json(
            [
                'message' => 'Error al actualizar el comentario',
                'errors' => $validator->errors(),
            ],
            Response::HTTP_BAD_REQUEST
        );
    }

    // Validar campos vacíos
    $errors = [];
    $fields = [
        'coment',
        'status_feedback',
        'id_courses',
        'external_user_id',
        'id_class',
    ];

    foreach ($fields as $field) {
        if ($request->has($field) ){
            if (empty($request->$field)) {
                $errors[$field] = 'El campo ' . $field . ' no puede estar vacío.';
            }
        }
    }

    if (!empty($errors)) {
        return response()->json(
            [
                'message' => 'Error al actualizar el comentario: campos vacíos',
                'errors' => $errors,
            ],
            Response::HTTP_BAD_REQUEST
        );
    }

    // Actualizar solo los campos proporcionados
    $dataToUpdate = array_filter($request->only([
        'coment',
        'status_feedback',
        'id_courses',
        'external_user_id',
        'id_class',
    ]), function ($value) {
        return !empty($value); // Filtra campos vacíos
    });

    $feedback->fill($dataToUpdate);
    $feedback->save();

    // Mensaje de actualización realizada
    return response()->json(
        [
            'message' => 'Comentario actualizado correctamente',
            'data' => $feedback,
        ],
        Response::HTTP_OK
    );
}

public function getByCourse($id_courses)
{
    // Verificar si el curso existe
    if (!Course::where('id_courses', $id_courses)->exists()) {
        return response()->json([
            'success' => false,
            'message' => 'Curso no encontrado'
        ], 404);
    }

    $comments = Feed::where('id_courses', $id_courses)
        ->select('id_feedback', 'external_user_id', 'coment', 'status_feedback', 'created_at')
        ->orderBy('created_at', 'asc')
        ->get();

    return response()->json([
        'success' => true,
        'data' => $comments
    ]);
}
public function getAnswersByFeedback($id_feedback)
{
    // Validar que el comentario existe
    $feedback = Feed::find($id_feedback);
    
    if (!$feedback) {
        return response()->json([
            'success' => false,
            'message' => 'Comentario no encontrado'
        ], 404);
    }

    // Obtener las respuestas con los campos específicos
    $answers = Answer::where('id_feedback', $id_feedback)
        ->select('id_answer', 'coment', 'answer_status', 'external_user_id', 'id_feedback', 'created_at')
        ->with(['externalUser' => function($query) {
            $query->select('id', 'username', 'firstname', 'lastname');
        }])
        ->orderBy('created_at', 'asc')
        ->get();

    return response()->json([
        'success' => true,
        'feedback_id' => $id_feedback,
        'answers' => $answers
    ]);

}
}