<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ClassLife;
use App\Models\Feed;

class ClassFeedbackController extends Controller
{
    public function getCommentsByClass($id_class, Request $request)
{
    // Verificar si la clase existe
    $class = ClassLife::find($id_class);
    
    if (!$class) {
        return response()->json([
            'success' => false,
            'message' => 'Clase no encontrada'
        ], 404);
    }

    // Obtener los comentarios paginados con conteo de respuestas
    $comments = Feed::where('id_class', $id_class)
        ->with(['externalUser' => function($query) {
            $query->select('id', 'username', 'firstname', 'lastname');
        }])
        ->withCount('answers')
        ->orderBy('created_at', 'desc')
        ->paginate(10);

    // Calcular totales
    $totalComments = $comments->total(); // Total de comentarios (todas las páginas)
    $totalAnswers = $comments->sum('answers_count'); // Suma de respuestas de TODOS los comentarios
    $totalInteractions = $totalComments + $totalAnswers; // Suma combinada

    // Estructurar la respuesta
    $response = [
        'success' => true,
        'class' => $class->only(['id_class', 'class_name']), // Ajusta según tu modelo
        'pagination' => [
            'total' => $totalComments,
            'per_page' => $comments->perPage(),
            'current_page' => $comments->currentPage(),
            'last_page' => $comments->lastPage(),
            'from' => $comments->firstItem(),
            'to' => $comments->lastItem(),
        ],
        'comments' => $comments->map(function($comment) {
            return [
                'id_feedback' => $comment->id_feedback,
                'coment' => $comment->coment,
                'status_feedback' => $comment->status_feedback,
                'created_at' => $comment->created_at,
                'external_user' => $comment->externalUser,
                'answers_count' => $comment->answers_count,
            ];
        }),
        'stats' => [
            'total_comments' => $totalComments,
            'total_answers' => $totalAnswers,
            'total_interactions' => $totalInteractions,
        ],
        'message' => "Interacciones obtenidas exitosamente"
    ];

    return response()->json($response);
}
}