<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Califications;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpFoundation\Response;

class CalificationsController extends Controller
{

    public function listCalifications(Request $request)
    {

        $perPage = $request->input('per_page', 20);

        $califications = Califications::paginate($perPage);

        if ($califications->isEmpty()) {
            return response()->json(['message' => 'No hay calificaciones registradas'], Response::HTTP_NOT_FOUND);
        }

        return response()->json($califications, Response::HTTP_OK);
    }

    public function registerCalifications(Request $Request)
    {
        $validator = Validator::make($Request->all(), [

            'nota_califications' => 'required|max:2',
            'promedio_califications' => 'required|max:2',
            'status_califications' => 'required|max:50',
            'id_courses' => 'required',
            'id_user' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => 'Error al registrar la calificacion', 'errors' =>
            $validator->errors()], Response::HTTP_BAD_REQUEST);
        }

        $calification = Califications::create([
            'nota_califications' => $Request->nota_califications,
            'promedio_califications' => $Request->promedio_califications,
            'status_califications' => $Request->status_califications,
            'id_courses' => $Request->id_courses,
            'id_user' => $Request->id_user
        ]);

        if (!$calification) {
            return response()->json(['message' => 'Error al registrar la calificacion'], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
        return response()->json([
            'message' => 'Calificacion registrada correctamente',
            'data' => $calification
        ], Response::HTTP_OK);
    }

    public function upgradePartialCalifications(Request $request, $id_califications)
    {
        //busqueda por id
        $calification = Califications::find($id_califications);
        if (!$calification) {
            //si no existe retorna un mensaje de error
            return response()->json(
                ['message' => 'No se encontro la calificacion'],
                Response::HTTP_NOT_FOUND
            );
        }

        //valido los datos a actualizar
        $validator = Validator::make($request->all(), [
            'nota_califications' => 'required|max:2',
            'promedio_califications' => 'required|max:2',
            'status_califications' => 'required|max:50',
            'id_courses' => 'required',
            'id_user' => 'required',
        ]);

        //si los datos son invalidos mensaje de error
        if ($validator->fails()) {
            return response()->json(
                [
                    'message' => 'Error al actualizar la calificacion',
                    'errors' => $validator->errors(),
                ],
                Response::HTTP_BAD_REQUEST
            );
        }

        // solicitud de los datos a actualizar
        if ($request->has('nota_califications')) {
            $calification->nota_califications = $request->nota_califications;
        }

        if ($request->has('promedio_califications')) {
            $calification->promedio_califications = $request->promedio_califications;
        }

        if ($request->has('fecha_califications')) {
            $calification->fecha_califications = $request->fecha_califications;
        }

        if ($request->has('status_califications')) {
            $calification->status_califications = $request->status_califications;
        }

        if ($request->has('id_courses')) {
            $calification->id_courses = $request->id_courses;
        }

        if ($request->has('id_user')) {
            $calification->id_user = $request->id_user;
        }

        //guardar los datos suministrados
        $calification->save();

        //mensaje de actualizacion realizada
        return response()->json(
            ['message' => $calification],
            Response::HTTP_OK
        );
    }

    public function showCalifications($id_califications)
    {
        $id_califications = Califications::find($id_califications);
        if (!$id_califications) {
            //si no existe retorna un mensaje de error
            return response()->json(
                ['message' => 'No se encontro la calificacion'],
                Response::HTTP_NOT_FOUND
            );
        }

        //si existe retorna un mensaje con los datos solicitados
        return response()->json(
            ['message' => $id_califications],
            Response::HTTP_OK
        );
    }
}
